---
generated_at: 2026-02-01 11:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 13
  claims_without_evidence: 3
confidence_derived: 0.81
---

# 根拠レポート：50-Kerberos 5（Heimdal）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.81**
  - 根拠あり：13 / 16、根拠なし：3
- 優先レビュー（高）
  1. **KDC内部処理フローの詳細**：AS-REQ/TGS-REQ処理の具体的実装
  2. **HDBデータベースバックエンドの詳細**：サポートされるバックエンド種別
  3. **GSSAPIメカニズムの詳細仕様**：サポートされる暗号タイプ一覧

## 2) 参照した情報（Evidence一覧）

- E-01: `kerberos5/` - FreeBSD統合ディレクトリ構造確認
- E-02: `crypto/heimdal/` - Heimdalソースツリーディレクトリ確認
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Heimdal Kerberos 5実装 | E-02, E-03 | ○ |
| C-02 | kerberos5/配下のFreeBSD統合構造 | E-01（include, lib, libexec, usr.bin, usr.sbin確認） | ○ |
| C-03 | crypto/heimdal/配下のHeimdal本体 | E-02（kdc, lib, appl, admin, tools確認） | ○ |
| C-04 | Makefile/Makefile.incの存在 | E-01 | ○ |
| C-05 | READMEの存在 | E-01 | ○ |
| C-06 | usr.binディレクトリの存在 | E-01 | ○ |
| C-07 | usr.sbinディレクトリの存在 | E-01 | ○ |
| C-08 | libディレクトリの存在 | E-01 | ○ |
| C-09 | libexecディレクトリの存在 | E-01 | ○ |
| C-10 | includeディレクトリの存在 | E-01 | ○ |
| C-11 | toolsディレクトリの存在 | E-01 | ○ |
| C-12 | kdc/ディレクトリの存在 | E-02 | ○ |
| C-13 | lib/gssapi/ディレクトリの存在 | E-02 | ○ |
| C-14 | KDC内部処理フロー（AS-REQ/TGS-REQ）の詳細 | **根拠なし** | △ |
| C-15 | HDBデータベースバックエンド種別 | **根拠なし** | △ |
| C-16 | サポートされる暗号タイプ一覧 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- KDC処理フロー詳細：crypto/heimdal/kdc/配下のソースコード読解が必要
  - 候補：crypto/heimdal/kdc/kdc-tgs.c / kdc/kdc-as.c
- HDBバックエンド：lib/hdb/配下のデータベースドライバ一覧
  - 候補：crypto/heimdal/lib/hdb/ のソース一覧
- 暗号タイプ：サポートされるenctype一覧（AES256-CTS-HMAC-SHA1-96等）
  - 候補：crypto/heimdal/lib/krb5/crypto.c / lib/asn1/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ディレクトリ構造と全体アーキテクチャは確認済み
- 2: 高リスク - KDC内部処理とHDBバックエンドの詳細はソース深部の読解が必要

## 6) レビュアーチェックリスト（最小）
- [ ] KDCのAS-REQ/TGS-REQ処理フローが正確か確認
- [ ] サポートされる暗号タイプ一覧を確認
- [ ] HDBデータベースバックエンド（LMDB, BDB等）の記述確認
- [ ] GSSAPIメカニズムの対応状況を確認
- [ ] Active Directory連携の具体的設定が正確か確認
